/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.action;

import de.willuhn.io.FileCopy;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.widgets.FileDialog;

public class LogExport
implements Action {
    @Override
    public void handleAction(Object context) throws ApplicationException {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            FileDialog dialog = new FileDialog(GUI.getShell(), 8192);
            dialog.setText(Application.getI18n().tr("Bitte w\u00e4hlen Sie Verzeichnis und Datei aus, in dem die Log-Datei gespeichert werden soll."));
            dialog.setFilterPath(System.getProperty("user.home"));
            dialog.setFileName("jameica-" + format.format(new Date()) + ".log");
            dialog.setOverwrite(true);
            String file = dialog.open();
            if (file == null || file.length() == 0) {
                return;
            }
            FileCopy.copy((File)new File(Application.getConfig().getLogFile()), (File)new File(file), (boolean)true);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Log-Datei gespeichert."), 0));
        }
        catch (Exception e) {
            Logger.error((String)"unable to export log file", (Throwable)e);
            throw new ApplicationException(Application.getI18n().tr("Fehler beim Speichern der Log-Datei"));
        }
    }
}

